/* A widget / interactor that lets you select one of multiple
 * different options for a list. This was originally created
 * as a temporary workaround for a bug in GChooser but can be
 * used in other contexts as well.
 */

#pragma once

#include "ProblemHandler.h"
#include "optional.h"
#include "ginteractors.h"
#include <string>

namespace MiniGUI {
    class Multiselector {
    public:
        /* Mode choices for the multiselector. */
        enum class Mode {
            FIRST_IS_DEFAULT
        };

        /* Constructs a new Multiselector associated with the given
         * ProblemHandler.
         */
        Multiselector(ProblemHandler* handler, const Vector<std::string>& options,
                      Mode mode = Mode::FIRST_IS_DEFAULT);

        /* Returns which item is selected, if any. There may be nothing
         * selected either if there's an explicit default of "nothing"
         * or if the selector is in FIRST_IS_DEFAULT mode but there is
         * no first item.
         */
        Optional<std::string> selection() const;
        Optional<int>         selectedIndex() const;

        /* React to events generated by the internal controls. These
         * return true if we are the source of the event and false
         * otherwise.
         */
        bool handleEvent(GObservable* source);

    private:
        GContainer* panel;
        GButton*    prev;
        GLabel*     label;
        GButton*    next;

        Vector<std::string> options;
        int cursor = 0;
        Mode mode;

        void updateDisplay();
    };
}
